/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import stormedpanda.simplyjetpacks.SimplyJetpacks;
import stormedpanda.simplyjetpacks.config.ConfigDefaults;
import stormedpanda.simplyjetpacks.config.JetpackConfig;
import stormedpanda.simplyjetpacks.item.JetpackType;

@Mod.EventBusSubscriber(modid="simplyjetpacks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimplyJetpacksConfig {
    public static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec.BooleanValue invertHoverSneakingBehavior;
    public static ForgeConfigSpec.BooleanValue enableJetpackSounds;
    public static ForgeConfigSpec.BooleanValue enableJetpackParticles;
    public static ForgeConfigSpec.BooleanValue showThrottle;
    public static ForgeConfigSpec.BooleanValue showExactEnergy;
    public static ForgeConfigSpec.BooleanValue enableStateMessages;
    public static ForgeConfigSpec.BooleanValue enableJetpackHud;
    public static ForgeConfigSpec.BooleanValue showHoverState;
    public static ForgeConfigSpec.BooleanValue showEHoverState;
    public static ForgeConfigSpec.BooleanValue showChargerState;
    public static ForgeConfigSpec.BooleanValue hudTextShadow;
    public static ForgeConfigSpec.IntValue hudTextColor;
    public static ForgeConfigSpec.IntValue hudXOffset;
    public static ForgeConfigSpec.IntValue hudYOffset;
    public static ForgeConfigSpec.LongValue hudScale;
    public static ForgeConfigSpec.EnumValue<ConfigDefaults.HUDPosition> hudTextPosition;
    public static ForgeConfigSpec.BooleanValue enableIntegrationVanilla;
    public static ForgeConfigSpec.BooleanValue enableIntegrationImmersiveEngineering;
    public static ForgeConfigSpec.BooleanValue enableIntegrationMekanism;
    public static ForgeConfigSpec.BooleanValue enableIntegrationEnderIO;
    public static ForgeConfigSpec.BooleanValue enableIntegrationThermalExpansion;
    public static ForgeConfigSpec.BooleanValue enableIntegrationThermalDynamics;
    public static ForgeConfigSpec.BooleanValue enableJoinAdvancements;

    public static void register() {
        SimplyJetpacksConfig.setupClientConfig();
        SimplyJetpacksConfig.setupCommonConfig();
        SimplyJetpacksConfig.setupServerConfig();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
        COMMON_CONFIG = COMMON_BUILDER.build();
        SERVER_CONFIG = SERVER_BUILDER.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_CONFIG);
    }

    private static void setupClientConfig() {
        CLIENT_BUILDER.comment("Simply Jetpacks 2 - Client Configurations").push("simplyjetpacks-client");
        CLIENT_BUILDER.comment("Controls Configurations").push("controls");
        invertHoverSneakingBehavior = CLIENT_BUILDER.comment("This sets whether you must hold sneak to hover.").translation("config.simplyjetpacks.invertHoverSneakingBehavior").define("invertHoverSneakingBehavior", false);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("Audio Configurations").push("audio");
        enableJetpackSounds = CLIENT_BUILDER.comment("This sets whether Jetpack sounds will play.").translation("config.simplyjetpacks.enableJetpackSounds").define("enableJetpackSounds", true);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("Visual Configurations").push("visual");
        enableJetpackParticles = CLIENT_BUILDER.comment("This sets whether Jetpack particles will be displayed.").translation("config.simplyjetpacks.enableJetpackParticles").define("enableJetpackParticles", true);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("GUI Configurations").push("gui");
        showThrottle = CLIENT_BUILDER.comment("Show the Throttle value in the Jetpack HUD.").translation("config.simplyjetpacks.showThrottle").define("showThrottle", true);
        showExactEnergy = CLIENT_BUILDER.comment("Show the exact energy of the Jetpack in the HUD.").translation("config.simplyjetpacks.showExactEnergy").define("showExactEnergy", false);
        enableStateMessages = CLIENT_BUILDER.comment("This sets whether or not Jetpack state messages will show.").translation("config.simplyjetpacks.enableStateMessages").define("enableStateMessages", true);
        enableJetpackHud = CLIENT_BUILDER.comment("This sets whether or not the Jetpack HUD will be visible.").translation("config.simplyjetpacks.enableJetpackHud").define("enableJetpackHud", true);
        showHoverState = CLIENT_BUILDER.comment("Show the Hover State in the HUD.").translation("config.simplyjetpacks.showHoverState").define("showHoverState", true);
        showEHoverState = CLIENT_BUILDER.comment("Show the Emergency Hover State in the HUD.").translation("config.simplyjetpacks.showEHoverState").define("showEHoverState", true);
        showChargerState = CLIENT_BUILDER.comment("Show the Charger State in the HUD.").translation("config.simplyjetpacks.showChargerState").define("showChargerState", true);
        hudTextColor = CLIENT_BUILDER.comment("This sets the color of the Jetpack HUD.").translation("config.simplyjetpacks.hudTextColor").defineInRange("hudTextColor", 0xFFFFFF, Integer.MIN_VALUE, Integer.MAX_VALUE);
        hudTextPosition = CLIENT_BUILDER.comment("Set the position of the Jetpack HUD on the screen.").translation("config.simplyjetpacks.hudTextPosition").defineEnum("hudTextPosition", (Enum)ConfigDefaults.hudTextPosition);
        hudXOffset = CLIENT_BUILDER.comment("Set the X offset of the Jetpack HUD on the screen.").translation("config.simplyjetpacks.hudXOffset").defineInRange("hudXOffset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        hudYOffset = CLIENT_BUILDER.comment("Set the Y offset of the Jetpack HUD on the screen.").translation("config.simplyjetpacks.hudYOffset").defineInRange("hudYOffset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        hudScale = CLIENT_BUILDER.comment("Set the scale of the Jetpack HUD on the screen.").translation("config.simplyjetpacks.hudScale").defineInRange("hudScale", 1L, 1L, 100L);
        hudTextShadow = CLIENT_BUILDER.comment("Set if the Jetpack HUD values have text shadows.").translation("config.simplyjetpacks.hudTextShadow").define("hudTextShadow", true);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
    }

    private static void setupCommonConfig() {
        COMMON_BUILDER.comment("Simply Jetpacks 2 - Common Configurations").push("simplyjetpacks-common");
        COMMON_BUILDER.comment("Integration Configurations").push("integration");
        enableIntegrationVanilla = COMMON_BUILDER.comment("Enable Vanilla Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationVanilla").worldRestart().define("enableIntegrationVanilla", true);
        enableIntegrationImmersiveEngineering = COMMON_BUILDER.comment("Enable Immersive Engineering Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationImmersiveEngineering").worldRestart().define("enableIntegrationImmersiveEngineering", true);
        enableIntegrationMekanism = COMMON_BUILDER.comment("Enable Mekanism Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationMekanism").worldRestart().define("enableIntegrationMekanism", true);
        enableIntegrationEnderIO = COMMON_BUILDER.comment("Enable EnderIO Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationEnderIO").worldRestart().define("enableIntegrationEnderIO", true);
        enableIntegrationThermalExpansion = COMMON_BUILDER.comment("Enable Thermal Expansion Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationThermalExpansion").worldRestart().define("enableIntegrationThermalExpansion", true);
        enableIntegrationThermalDynamics = COMMON_BUILDER.comment("Enable Thermal Dynamics Jetpacks Integration.").translation("config.simplyjetpacks.enableIntegrationThermalDynamics").worldRestart().define("enableIntegrationThermalDynamics", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Jetpack Tuning Configurations").push("tuning");
        JetpackConfig.createJetpackConfig(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Misc Configurations").push("misc");
        enableJoinAdvancements = COMMON_BUILDER.comment("Enable Advancements on Player join.").translation("config.simplyjetpacks.enableJoinAdvancements").define("enableJoinAdvancements", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
    }

    private static void setupServerConfig() {
        SERVER_BUILDER.comment("Simply Jetpacks 2 - Server Configurations").push("simplyjetpacks-server");
        SERVER_BUILDER.pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        SimplyJetpacks.LOGGER.info("Config Loaded: {}", (Object)configEvent.getConfig().getFileName());
        JetpackType.loadAllConfigs();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        SimplyJetpacks.LOGGER.info("Config Re-Loaded: {}", (Object)configEvent.getConfig().getFileName());
        JetpackType.loadAllConfigs();
    }
}

